/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.core.config.IClientConfig;
import mezz.jei.core.config.IWorldConfig;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.ghost.GhostIngredientDragManager;
import mezz.jei.gui.overlay.ConfigButton;
import mezz.jei.gui.overlay.GuiProperties;
import mezz.jei.gui.overlay.IFilterTextSource;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.gui.overlay.IngredientGridWithNavigation;
import mezz.jei.ingredients.RegisteredIngredients;
import mezz.jei.input.GuiTextFieldFilter;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IRecipeFocusSource;
import mezz.jei.input.MouseUtil;
import mezz.jei.input.mouse.ICharTypedHandler;
import mezz.jei.input.mouse.IUserInputHandler;
import mezz.jei.input.mouse.handlers.CheatInputHandler;
import mezz.jei.input.mouse.handlers.CombinedInputHandler;
import mezz.jei.input.mouse.handlers.NullInputHandler;
import mezz.jei.input.mouse.handlers.ProxyInputHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import org.jetbrains.annotations.Nullable;

public class IngredientListOverlay
implements IIngredientListOverlay,
IRecipeFocusSource,
ICharTypedHandler {
    private static final int BORDER_MARGIN = 6;
    private static final int INNER_PADDING = 2;
    private static final int BUTTON_SIZE = 20;
    private static final int SEARCH_HEIGHT = 20;
    private final GuiIconToggleButton configButton;
    private final IngredientGridWithNavigation contents;
    private final IClientConfig clientConfig;
    private final IWorldConfig worldConfig;
    private final IConnectionToServer connectionToServer;
    private final GuiScreenHelper guiScreenHelper;
    private final GuiTextFieldFilter textFieldFilter;
    private final GhostIngredientDragManager ghostIngredientDragManager;
    private ImmutableRect2i displayArea = ImmutableRect2i.EMPTY;
    private boolean hasRoom;
    @Nullable
    private IGuiProperties guiProperties;

    public IngredientListOverlay(IIngredientGridSource ingredientGridSource, IFilterTextSource filterTextSource, RegisteredIngredients registeredIngredients, GuiScreenHelper guiScreenHelper, IngredientGridWithNavigation contents, IClientConfig clientConfig, IWorldConfig worldConfig, IConnectionToServer connectionToServer) {
        this.guiScreenHelper = guiScreenHelper;
        this.contents = contents;
        this.clientConfig = clientConfig;
        this.worldConfig = worldConfig;
        this.connectionToServer = connectionToServer;
        this.textFieldFilter = new GuiTextFieldFilter();
        this.textFieldFilter.m_94144_(filterTextSource.getFilterText());
        this.textFieldFilter.m_93692_(false);
        this.textFieldFilter.m_94151_(filterTextSource::setFilterText);
        filterTextSource.addListener(this.textFieldFilter::m_94144_);
        ingredientGridSource.addSourceListChangedListener(() -> this.updateBounds(true));
        this.configButton = ConfigButton.create(this, worldConfig);
        this.ghostIngredientDragManager = new GhostIngredientDragManager(this.contents, guiScreenHelper, registeredIngredients, worldConfig);
    }

    public boolean isListDisplayed() {
        return this.worldConfig.isOverlayEnabled() && this.guiProperties != null && this.hasRoom;
    }

    private static ImmutableRect2i createDisplayArea(IGuiProperties guiProperties) {
        ImmutableRect2i screenRectangle = GuiProperties.getScreenRectangle(guiProperties);
        int guiRight = GuiProperties.getGuiRight(guiProperties);
        return screenRectangle.cropLeft(guiRight).insetBy(6);
    }

    public void updateScreen(@Nullable Screen guiScreen, boolean exclusionAreasChanged) {
        IGuiProperties guiProperties = this.guiScreenHelper.getGuiProperties(guiScreen);
        if (guiProperties == null) {
            if (this.guiProperties != null) {
                this.guiProperties = null;
                this.textFieldFilter.m_93692_(false);
                this.ghostIngredientDragManager.stopDrag();
            }
        } else {
            boolean guiPropertiesChanged;
            boolean bl = guiPropertiesChanged = this.guiProperties == null || !GuiProperties.areEqual(this.guiProperties, guiProperties);
            if (exclusionAreasChanged || guiPropertiesChanged) {
                this.updateNewScreen(guiProperties, guiPropertiesChanged);
            }
        }
    }

    private void updateNewScreen(IGuiProperties guiProperties, boolean guiPropertiesChanged) {
        this.guiProperties = guiProperties;
        this.displayArea = IngredientListOverlay.createDisplayArea(guiProperties);
        if (guiPropertiesChanged) {
            this.ghostIngredientDragManager.stopDrag();
        }
        this.updateBounds(false);
    }

    private void updateBounds(boolean resetToFirstPage) {
        if (this.guiProperties == null) {
            return;
        }
        boolean searchBarCentered = IngredientListOverlay.isSearchBarCentered(this.clientConfig, this.guiProperties);
        ImmutableRect2i availableContentsArea = this.getAvailableContentsArea(searchBarCentered);
        Set<ImmutableRect2i> guiExclusionAreas = this.guiScreenHelper.getGuiExclusionAreas();
        this.hasRoom = this.contents.updateBounds(availableContentsArea, guiExclusionAreas);
        ImmutableRect2i searchAndConfigArea = this.getSearchAndConfigArea(searchBarCentered, this.guiProperties);
        ImmutableRect2i searchArea = searchAndConfigArea.cropRight(20);
        ImmutableRect2i configButtonArea = searchAndConfigArea.keepRight(20);
        int searchTextColor = this.contents.isEmpty() ? -65536 : -1;
        this.textFieldFilter.m_94202_(searchTextColor);
        this.textFieldFilter.updateBounds(searchArea);
        this.configButton.updateBounds(configButtonArea);
        if (this.hasRoom) {
            this.contents.updateLayout(resetToFirstPage);
        }
    }

    private static boolean isSearchBarCentered(IClientConfig clientConfig, IGuiProperties guiProperties) {
        return clientConfig.isCenterSearchBarEnabled() && GuiProperties.getGuiBottom(guiProperties) + 20 < guiProperties.getScreenHeight();
    }

    private ImmutableRect2i getAvailableContentsArea(boolean searchBarCentered) {
        if (searchBarCentered) {
            return this.displayArea;
        }
        return this.displayArea.cropBottom(22);
    }

    private ImmutableRect2i getSearchAndConfigArea(boolean searchBarCentered, IGuiProperties guiProperties) {
        if (searchBarCentered) {
            ImmutableRect2i guiRectangle = GuiProperties.getGuiRectangle(guiProperties);
            return this.displayArea.keepBottom(20).matchWidthAndX(guiRectangle);
        }
        if (this.hasRoom) {
            ImmutableRect2i contentsArea = this.contents.getBackgroundArea();
            return this.displayArea.keepBottom(20).matchWidthAndX(contentsArea);
        }
        return this.displayArea.keepBottom(20);
    }

    public void drawScreen(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isListDisplayed()) {
            this.textFieldFilter.m_6303_(poseStack, mouseX, mouseY, partialTicks);
            this.contents.draw(minecraft, poseStack, mouseX, mouseY, partialTicks);
        }
        if (this.guiProperties != null) {
            this.configButton.draw(poseStack, mouseX, mouseY, partialTicks);
        }
    }

    public void drawTooltips(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        if (this.isListDisplayed()) {
            this.ghostIngredientDragManager.drawTooltips(minecraft, poseStack, mouseX, mouseY);
            this.contents.drawTooltips(minecraft, poseStack, mouseX, mouseY);
        }
        if (this.guiProperties != null) {
            this.configButton.drawTooltips(poseStack, mouseX, mouseY);
        }
    }

    public void drawOnForeground(Minecraft minecraft, PoseStack poseStack, AbstractContainerScreen<?> gui, int mouseX, int mouseY) {
        if (this.isListDisplayed()) {
            poseStack.m_85836_();
            poseStack.m_85837_((double)(-gui.getGuiLeft()), (double)(-gui.getGuiTop()), 0.0);
            this.ghostIngredientDragManager.drawOnForeground(minecraft, poseStack, mouseX, mouseY);
            poseStack.m_85849_();
        }
    }

    public void handleTick() {
        if (this.isListDisplayed()) {
            this.textFieldFilter.m_94120_();
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        if (this.isListDisplayed()) {
            if (this.clientConfig.isCenterSearchBarEnabled() && this.textFieldFilter.m_5953_(mouseX, mouseY)) {
                return true;
            }
            return this.displayArea.contains(mouseX, mouseY) && !this.guiScreenHelper.isInGuiExclusionArea(mouseX, mouseY);
        }
        if (this.guiProperties != null) {
            return this.configButton.isMouseOver(mouseX, mouseY);
        }
        return false;
    }

    @Override
    public Stream<IClickedIngredient<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isListDisplayed()) {
            return this.contents.getIngredientUnderMouse(mouseX, mouseY);
        }
        return Stream.empty();
    }

    public IUserInputHandler createInputHandler() {
        CombinedInputHandler displayedInputHandler = new CombinedInputHandler(this.ghostIngredientDragManager.createInputHandler(), this.textFieldFilter.createInputHandler(), this.configButton.createInputHandler(), this.contents.createInputHandler(), new CheatInputHandler(this.contents, this.worldConfig, this.clientConfig, this.connectionToServer));
        IUserInputHandler hiddenInputHandler = this.configButton.createInputHandler();
        return new ProxyInputHandler(() -> {
            if (this.guiProperties == null) {
                return NullInputHandler.INSTANCE;
            }
            if (this.isListDisplayed()) {
                return displayedInputHandler;
            }
            return hiddenInputHandler;
        });
    }

    @Override
    public boolean hasKeyboardFocus() {
        return this.isListDisplayed() && this.textFieldFilter.m_93696_();
    }

    @Override
    public boolean onCharTyped(char codePoint, int modifiers) {
        return this.textFieldFilter.m_5534_(codePoint, modifiers);
    }

    @Override
    public Optional<ITypedIngredient<?>> getIngredientUnderMouse() {
        if (this.isListDisplayed()) {
            double mouseX = MouseUtil.getX();
            double mouseY = MouseUtil.getY();
            return this.contents.getIngredientUnderMouse(mouseX, mouseY).map(IClickedIngredient::getTypedIngredient).findFirst();
        }
        return Optional.empty();
    }

    @Override
    @Nullable
    public <T> T getIngredientUnderMouse(IIngredientType<T> ingredientType) {
        if (this.isListDisplayed()) {
            double mouseX = MouseUtil.getX();
            double mouseY = MouseUtil.getY();
            return this.contents.getIngredientUnderMouse(mouseX, mouseY).map(IClickedIngredient::getTypedIngredient).map(i -> i.getIngredient(ingredientType)).flatMap(Optional::stream).findFirst().orElse(null);
        }
        return null;
    }

    @Override
    public <T> List<T> getVisibleIngredients(IIngredientType<T> ingredientType) {
        if (this.isListDisplayed()) {
            return this.contents.getVisibleIngredients(ingredientType).toList();
        }
        return Collections.emptyList();
    }
}

